# Impermanence

Impermanence is a way of wiping all of your files, except select portions, on every boot. This can avoid you having uncleaned-up mess as you will need to explicitly declare where all your files are

## Use on personal systems

Unlike servers, personal systems are generally not set up for impermanence. Therefore, impermanence will cause some compatibility issues:

- You cannot use `users.mutableUsers = true;` (the default) with impermanence ([nix-community/impermanence#88](https://github.com/nix-community/impermanence/pull/88)), so you will need to manually set a password for your user
- If you use the home-manager impermanence options [your home will no longer be compatible with direct use with `nilla home`](https://github.com/nix-community/impermanence/blob/4b3e914cdf97a5b536a889e939fb2fd2b043a170/README.org?plain=1#L340-L342) and will need to be attached to a system

## Cleanup

Impermanence won't clean up your system when an ingredient changes where it stores data (or where you remove an ingredient as you are no longer using it).

In the future, we will write a script to help you clean up. For now, this has to be done manually.